<?php
include("../config.php");
$error_message = '';
$success_message = '';
// Check if the user is logged in or not
if(!isset($_SESSION['admin'])) {
    header('location: login.php');
    exit;
}
$cur_page = substr($_SERVER["SCRIPT_NAME"],strrpos($_SERVER["SCRIPT_NAME"],"/")+1);
?>
<!DOCTYPE html>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- Page title -->
    <title>Admin Dashboard | <?php echo $meta_title_home; ?></title>

    <!-- Place favicon.ico and apple-touch-icon.png in the root directory -->
    <link rel="shortcut icon" type="image/png" href="<?php echo BASE_URL; ?>images/<?php echo $favicon; ?>" />

    <!-- Vendor styles -->
    <link rel="stylesheet" href="vendor/fontawesome/css/font-awesome.css" />
    <link rel="stylesheet" href="vendor/metisMenu/dist/metisMenu.css" />
    <link rel="stylesheet" href="vendor/animate.css/animate.css" />
    <link rel="stylesheet" href="vendor/bootstrap/dist/css/bootstrap.css" />
    <link href="styles/dropify.css" type="text/css" rel="stylesheet" media="screen,projection">

    <!-- App styles -->
    <link rel="stylesheet" href="fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css" />
    <link rel="stylesheet" href="fonts/pe-icon-7-stroke/css/helper.css" />
    <link rel="stylesheet" href="styles/style.css">
    <link rel="stylesheet" href="styles/custom.css">

</head>
<body class="fixed-navbar fixed-sidebar">

<!--[if lt IE 7]>
<p class="alert alert-danger">You are using an <strong>outdated</strong> browser. Please <a href="http://browsehappy.com/">upgrade your browser</a> to improve your experience.</p>
<![endif]-->

<!-- Header -->
<div id="header">
    <div class="color-line">
    </div>
    <div id="logo" class="dark-version">
        <span>
            <?php echo htmlspecialchars($meta_title_home, ENT_QUOTES, 'UTF-8'); ?>
        </span>
    </div>
    <nav role="navigation">
        <div class="header-link hide-menu"><i class="fa fa-bars"></i></div>
        <div class="small-logo">
            <span class="text-primary"><?php echo htmlspecialchars($meta_title_home, ENT_QUOTES, 'UTF-8'); ?></span>
        </div>
        <div class="mobile-menu">
            <button type="button" class="navbar-toggle mobile-menu-toggle" data-toggle="collapse" data-target="#mobile-collapse">
                <i class="fa fa-chevron-down"></i>
            </button>
            <div class="collapse mobile-navbar" id="mobile-collapse">
                <ul class="nav navbar-nav">
                    <li>
                        <a class="" href="<?php echo BASE_URL; ?>">Homepage</a>
                    </li>
                    <li>
                        <a class="" href="<?php echo BASE_URL; ?>admin/profile.php">Profile</a>
                    </li>
                    <li>
                        <a class="" href="<?php echo BASE_URL; ?>admin/logout.php">Logout</a>
                    </li>
                </ul>
            </div>
        </div>
        <div class="navbar-right">
            <ul class="nav navbar-nav no-borders">
                <li class="dropdown">
                    <a href="<?php echo BASE_URL; ?>" target="_blank">
                        <i class="pe-7s-home"></i>
                    </a>
                </li>
                <li class="dropdown">
                    <a href="<?php echo BASE_URL; ?>admin/profile.php">
                        <i class="pe-7s-user"></i>
                    </a>
                </li>
                <li class="dropdown">
                    <a href="<?php echo BASE_URL; ?>admin/logout.php">
                        <i class="pe-7s-upload pe-rotate-90"></i>
                    </a>
                </li>
            </ul>
        </div>
    </nav>
</div>